#!/bin/bash

echo "Building Apple plugins"

CLONED_APPLE_PLUGINS_REPO_FOLDER="AppleGameKitPlugins"
PYTHON_SCRIPT_UPLOAD_TARBALLS="BuildScripts/CompileApplePlugins/upload_tarballs.py"
PYTHON_REQUIREMENTS_FILE="BuildScripts/CompileApplePlugins/requirements.txt"

# To know the exact filenames you can find by searching in the log for the string 'Packing plug-in'. If not found likely build failed.
EXPECTED_CORE_BUILD_FILE="$CLONED_APPLE_PLUGINS_REPO_FOLDER/Build/com.apple.unityplugin.core-3.1.8.tgz"
EXPECTED_GAMEKIT_BUILD_FILE="$CLONED_APPLE_PLUGINS_REPO_FOLDER/Build/com.apple.unityplugin.gamekit-3.0.2.tgz"

# Had issue this apple script had no permission to be executed
chmod 777 "$CLONED_APPLE_PLUGINS_REPO_FOLDER/scripts/shell/copy_native_libraries.sh"

echo "Running build command"
cd "$CLONED_APPLE_PLUGINS_REPO_FOLDER"

# The 'n' to say no to the question whether we want to compile for MAC too
python3 build.py -p Core GameKit -m iOS -bc Release <<EOF
n
EOF

cd ..
echo "Finished build command"

echo "Listing artifacts in build folder"
# It usually not shows the files for some reason, only the occupied space
ls -la "$CLONED_APPLE_PLUGINS_REPO_FOLDER/Build/"

# Some validations
test -f "$EXPECTED_CORE_BUILD_FILE" && echo "Apple Core plugin exists" || echo "Apple Core plugin missing"
test -f "$EXPECTED_GAMEKIT_BUILD_FILE" && echo "Apple GameKit plugin exists" || echo "Apple GameKit plugin missing"

echo "Preparing upload apple unity plugins build results: Installing python packages"
pip install -r "$PYTHON_REQUIREMENTS_FILE"

echo "Executing the python script to upload apple unity tarballs"
python3 "$PYTHON_SCRIPT_UPLOAD_TARBALLS"

echo "FINISH: Apple plugins compiled and uploaded to unity artifacts."
