from pathlib import Path
from googleapiclient.discovery import build
from google.oauth2 import service_account


DRIVE_SERVICE_ACCOUNT_FILE = 'BuildScripts/CompileApplePlugins/drive_service_account.json'
DRIVE_UPLOAD_FOLDER_ID = 'FAKE_FOLDER_ID (PASTE YOUR OWN)'
EXPECTED_CORE_BUILD_FILE="AppleGameKitPlugins/Build/com.apple.unityplugin.core-3.1.8.tgz"
EXPECTED_GAMEKIT_BUILD_FILE="AppleGameKitPlugins/Build/com.apple.unityplugin.gamekit-3.0.2.tgz"


class DriveApi:
    def __init__(self):
        self._scopes = ['https://www.googleapis.com/auth/drive']

    def _authenticate(self) -> service_account.Credentials:
        return service_account.Credentials.from_service_account_file(str(DRIVE_SERVICE_ACCOUNT_FILE), scopes=self._scopes)

    def upload_file(self, file_path: Path) -> None:
        creds = self._authenticate()
        service = build('drive', 'v3', credentials=creds)

        file_metadata = {
            'name': file_path.name,
            'parents': [DRIVE_UPLOAD_FOLDER_ID]
        }

        service.files().create(
            body=file_metadata,
            media_body=str(file_path)
        ).execute()


if __name__ == "__main__":
    drive_api = DriveApi()
    drive_api.upload_file(Path(EXPECTED_CORE_BUILD_FILE))
    drive_api.upload_file(Path(EXPECTED_GAMEKIT_BUILD_FILE))
